#version 330

in vec3 vColor;
in vec3 vNormal;

out vec4 fColor;

const vec3 directionToLight = normalize(vec3(0.5, 0.3, 0.6));

void main()
{
    float litColor;
    if (gl_FrontFacing)
    {
        litColor = clamp(dot(-vNormal, directionToLight), 0.0, 1.0);    
    }
    else
    {
        litColor = clamp(dot(vNormal, directionToLight), 0.0, 1.0);
    }
    
    fColor = vec4(vColor*litColor, 1);
}
